﻿// Superballs - Jim Bumgardner
kNbrBalls = 5;
gravK = 1.0;			// gravity
dampK = 0.99;       	// lower numbers make more air resistance
dampCollision = .95; 	// energy retained in collisions

ballRadius = 25;
ballWidth = ballRadius*2;

SH = Stage.height;
SW = Stage.width;

MovieClip.prototype.handleCollisions = function()
{
	for (var i = mcs.length-1; i >= 1; --i) {
		var x1 = mcs[i]._x;
		var y1 = mcs[i]._y;
		for (j = i-1; j >= 0; --j) {
			var dx = mcs[j]._x - x1;
			var dy = mcs[j]._y - y1;
			var dist = Math.sqrt(dx*dx+dy*dy);
			if (dist < ballWidth) {
				// collide - trade energy (mag1,mag2), and travel in opposite direction of collision
				var mag1 = Math.sqrt(mcs[i].vx*mcs[i].vx+mcs[i].vy*mcs[i].vy);
				var mag2 = Math.sqrt(mcs[j].vx*mcs[j].vx+mcs[j].vy*mcs[j].vy);
				mcs[j].vx = (mag1*dx/dist)*dampCollision;
				mcs[j].vy = (mag1*dy/dist)*dampCollision;
				mcs[i].vx = -(mag2*dx/dist)*dampCollision;
				mcs[i].vy = -(mag2*dy/dist)*dampCollision;
			}
		}
	}
}

MovieClip.prototype.pressBall = function()
{
	this.isDragging = true;
	this.vx = this.vy = 0;
	this.lmx = _root._xmouse;
	this.lmy = _root._ymouse;
	this.startDrag(false);
}

MovieClip.prototype.releaseBall = function()
{
	this.isDragging = false;
	this.stopDrag();
}

MovieClip.prototype.moveBall = function()
{
	// compute forces on ball
	if (!this.isDragging) {
		this.vx *= dampK;	// damping due to air resistance
		this.vy *= dampK;

		this.vy += gravK;	// gravity
		
		// bounce off floor and ceiling
		if (this._y+ballRadius + this.vy >= SH ||
			(this._y-ballRadius) + this.vy < 0)
		{
			this.vy *= -dampCollision;
		}
		// bounce off right and left walls
		if ((this._x-ballRadius) + this.vx <= 0 ||
			 this._x+ballRadius + this.vx >= SW)
		{
			this.vx *= -dampCollision;
		}
		this._x += this.vx;
		this._y += this.vy;
	}
	else {
		// Set vx,vy to correspond to mouse movement, enabling user to 'toss' ball
		this.vx *= dampK;
		this.vy *= dampK;
		this.vx = _root._xmouse - this.lmx;
		this.vy = _root._ymouse - this.lmy;
		this.lmx = _root._xmouse;
		this.lmy = _root._ymouse;
	}
}

mcs = [];
for (var i = 0; i < kNbrBalls; ++i) {
  var mc = this.attachMovie("superball_mc", "mc"+i, 1+i);
  mcs[i] = mc;
  mc._x = ballRadius+random(Stage.width-ballWidth);
  mc._y = ballRadius+random(Stage.height-ballWidth);
  mc.vx = Math.random()*32-16;
  mc.vy = Math.random()*32-16;
  mc._width = ballRadius*2;
  mc._height = ballRadius*2;
  mc.onEnterFrame = mc.moveBall;
  mc.onPress = mc.pressBall;
  mc.onRelease = mc.onReleaseOutside = mc.releaseBall;
}

_root.onEnterFrame = handleCollisions;
