// import group broadcaster
import com.senocular.GroupBroadcaster;

class BasicShape extends MovieClip {

	// basic shapes are generated from empty clips - use the empty clip in the library
	// flash automatically generated for this class as the symbol representing shape instances
	private static var linkage:String = "__Packages.BasicShape";
	private static var registerClass:Boolean = Object.registerClass(linkage, BasicShape);
	// define available colors with respective hex values
	private static var colors:Object = {red:0xFF3333, green:0x33FF33, blue:0x3333FF};
	
	// declare group broadcaster methods (much like AsBroadcaster)
	public static var addGroupListener:Function;
	public static var removeGroupListener:Function;
	public static var broadcastGroupMessage:Function;
	
	// variable controling shaking; shaking occurs while shaketime > 0
	private var shaketime:Number = 0;

	// static function create used to replace attachMovie for class instantiation
	// using create from BasicShape shows you're creating a BasicShape instance and
	// allows for more parameters to be passed (which then get used in the init method)
	public static function create(timeline:MovieClip, name:String, depth:Number, initObj:Object, shape:String, col:String, border:Boolean):BasicShape {
		var mc:BasicShape = BasicShape(timeline.attachMovie(linkage, name, depth, initObj));
		mc.init(shape, col, border);
		return mc;
	}

	// constructor
	function BasicShape(Void){
		// if the BasicShape class hasn't been initialized for GroupBroadcaster, do that now
		if (!broadcastGroupMessage){
			GroupBroadcaster.initialize(BasicShape);
			// the class object itself is used as a broadcaster here, not instances.  This lets
			// you use the class object to affect all instances of the class
		}
	}
	
	// init method assigning shape properties (shape, color and border)
	public function init(shape:String, col:String, border:Boolean):Void {
		var groups:Array = [shape, col];
		if (border == true) groups.push("hasBorder");
		
		// this is where the shape gets added as a listener of the BasicShape class
		// the groups array contains the groups by name pertaining to this shape.  Any
		// group broadcasted event for anyone of those groups will affect this shape
		addGroupListener(this, groups);
		
		// draw this shape based on the shape passed
		this["draw_" + shape](colors[col], border);
	}
	
	// override removeMovieClip so this shape can be removed as a listener
	public function removeMovieClip():Void {
		BasicShape.removeGroupListener(this);
		super.removeMovieClip();
	}
	
	// shakeFor initiates the shaking process by increasing the value of shaketime above 0
	public function shakeFor(frames:Number):Void {
		if (!this.shaketime){
			this.shaketime += frames + frames % 2;
		}
	}
	
	// onEnterFrame handles shaking as long as shaketime > 0
	private function onEnterFrame(Void):Void {
		if (this.shaketime > 0){
			this._x += (this.shaketime % 2) ? 3 : -3;
			this.shaketime--;
		}
	}

	// drawing methods for creating the shape
	private function draw_square(col:Number, border:Boolean):Void {
		if (border == true) this.lineStyle(3, 0, 100);
		this.beginFill(col, 100);
		this.moveTo(-10, -10);
		this.lineTo(10, -10);
		this.lineTo(10, 10);
		this.lineTo(-10, 10);
		this.lineTo(-10, -10);
		this.endFill();
	}
	private function draw_triangle(col:Number, border:Boolean):Void {
		if (border == true) this.lineStyle(3, 0, 100);
		this.beginFill(col, 100);
		this.moveTo(0, -10);
		this.lineTo(10, 10);
		this.lineTo(-10, 10);
		this.lineTo(0, -10);
		this.endFill();
	}
	private function draw_circle(col:Number, border:Boolean):Void {
		if (border == true) this.lineStyle(3, 0, 100);
		this.beginFill(col, 100);
		var r:Number = 10;
		var c1:Number = r*(Math.SQRT2-1);
		var c2:Number = r*(Math.SQRT2/2);
		this.moveTo(r,0);
		this.curveTo(r,c1,c2,c2);
		this.curveTo(c1,r,0,r);
		this.curveTo(-c1,r,-c2,c2);
		this.curveTo(-r,c1,-r,0);
		this.curveTo(-r,-c1,-c2,-c2);
		this.curveTo(-c1,-r,0,-r);
		this.curveTo(c1,-r,c2,-c2);
		this.curveTo(r,-c1,r,0);
		this.endFill();
	}

}