﻿// Basic news ticker, controlled by arrays, with various animation effects.
//
// Uses two movie clips, so that exits can overlap entrances.
//
// Jim Bumgardner

SW = Stage.width; // scene width
SH = Stage.height; // scene height
kEffectDuration = 2000;
kReadDuration = 2000;

// These arrays controls the animation for each item
// 0 = basic scroll (no exit effect)
// 1 = from/to left
// 2 = from/to right
// 3 = from/to top
// 4 = from/to bottom
// 5 = from/to tiny
// 6 = from/to big
var tickerItemDebut = [1,0,2,3,4,5,6,0];
var tickerItemExit =  [4,0,5,6,1,2,3,0];

var tickerItems = [
	'<font color="#FF0000">This is the first item in the ticker</font>',
	'<font color="#0000FF">This is the second item in the ticker.</font>',
	'<font color="#007777">This is the third item in the ticker.</font>',
	'<font color="#777700">This is the fourth item in the ticker.</font>',
	'<font color="#000000">This is the fifth item in the ticker.</font>',
	'<font color="#7700FF"><a href="http://www.krazydad.com" target="blank">This is the sixth item.</a></font>',
	'<font color="#0000FF"><a href="http://www.krazydad.com" target="blank">Item 7.</a></font>',
	'<font color="#770077"><a href="http://www.krazydad.com" target="_top">This ticker was brought to you by <u>krazydad.com</u></a>  -- stay tuned for more news...</font>'
	];

MovieClip.prototype.setTweenTargets = function(dstX,dstY,dstScale,dstAlpha)
{
	this.srcScale = this._xscale;
	this.srcX = this._x;
	this.srcY = this._y;
	this.srcAlpha = this._alpha;

	this.dstScale = dstScale;
	this.dstX = dstX;
	this.dstY = dstY;
	this.dstAlpha = dstAlpha;
}

MovieClip.prototype.setupDebut = function(n)
{
	// trace("debut " + n);
	this.startTime = getTimer();
	if (n == 0) {	// basic leftwards scroll effect
		this.ticker_txt._x = 0;
		this.ticker_txt._y = -this.ticker_txt.textHeight/2;
		this._xscale = 100;
		this._yscale = 100;
		this._alpha = 100;
		this._x = SW;
		this._y = SH/2;
		this.state = -1;
	}
	else {
		this.ticker_txt._x = -this.ticker_txt.textWidth/2;
		this.ticker_txt._y = -this.ticker_txt.textHeight/2;

		switch (n) {
		case 1: // from left
			this._alpha = 100;
			this._x = -this.ticker_txt.textWidth/2;
			this._y = SH/2;
			this._yscale = this._xscale = SW*100/(this.ticker_txt.textWidth+20);
			this.setTweenTargets(SW/2, this._y, this._xscale,100);
			break;
		case 2: // from right
			this._alpha = 100;
			this._x = SW+this.ticker_txt.textWidth/2;
			this._y = SH/2;
			this._yscale = this._xscale = Math.min(100,SW*100/(this.ticker_txt.textWidth+20));
			this.setTweenTargets(SW/2, this._y, this._xscale,100);
			break;
		case 3:	// from top
			this._x = SW/2;
			this._y = 0 - this.ticker_txt.textHeight/2;
			this._yscale = this._xscale = Math.min(100,SW*100/(this.ticker_txt.textWidth+20));
			this._alpha = 100;
			this.setTweenTargets(this._x, SH/2, this._xscale,100);
			break;
		case 4:	// from bottom
			this._alpha = 100;
			this._x = SW/2;
			this._y = SH+this.ticker_txt.textHeight;
			this._yscale = this._xscale = Math.min(100,SW*100/(this.ticker_txt.textWidth+20));
			this.setTweenTargets(this._x, SH/2, this._xscale,100);
			break;
		case 5:	// 3d fly-in/out from small
			this._alpha = 0;
			this._x = SW/2;
			this._y = SH/2;
			this._xscale = this._yscale = 1;
			this.setTweenTargets(this._x, this._y, Math.min(100,SW*100/(this.ticker_txt.textWidth+20)),100);
			break;
		case 6:	// 3d fly-in/out from large
			this._alpha = 0;
			this._x = SW/2;
			this._y = SH/2;
			this._yscale = this._xscale = SW*1000/(this.ticker_txt.textWidth+20);
			this.setTweenTargets(this._x, this._y, Math.min(100,SW*100/(this.ticker_txt.textWidth+20)),100);
			break;
		default:
			trace("debut: undefined type for " + this.idx);
		}
	}
}

MovieClip.prototype.setupExit = function(n)
{
	// trace("exit " + n);
	this.startTime = getTimer();
	switch (n) {
	case 1:	// exit to left
		this.setTweenTargets(-this.ticker_txt.textWidth/2, this._y, this._xscale,100);
		break;
	case 2:	// exit to right
		this.setTweenTargets(SW+this.ticker_txt.textWidth/2, this._y, this._xscale,100);
		break;
	case 3:	// exit up
		this.setTweenTargets(this._x, -this.ticker_txt.textHeight/2, this._xscale,100);
		break;
	case 4:	// exit down
		this.setTweenTargets(this._x, SH+this.ticker_txt.textHeight/2, this._xscale,100);
		break;
	case 5:	// exit small
		this.setTweenTargets(this._x, this._y, 1, 0);
		break;
	case 6:	// exit big
		this.setTweenTargets(this._x, this._y, SW*1000/(this.ticker_txt.textWidth+20), 0);
		break;
	default:
		trace("exit: undefined type for " + this.idx);
	}
}

MovieClip.prototype.getTickerItem = function(n)
{
	this._visible = true;
	this.idx = n;
	this.state = 0;
	this.ticker_txt.htmlText = tickerItems[n];
	this.setupDebut(tickerItemDebut[n]);
}

// This function animates the text
//
function cycleTicker()
{
	if (this._visible == false)
		return;

	var queueNext = false;

	switch (this.state) {
	case -1:	// regular scroll, as in basic_ticker
		this._x -= this.speed;
		queueNext = (this._x <= -this.ticker_txt.textWidth);
		if (queueNext)
			this._visible = false;
		break;
	case 0:		// debut effect?
	case 2:		// or exit effect?

	// Figure out where in the tween we are
		var r = (getTimer() - this.startTime)/kEffectDuration;
		if (r >= 1) {	// Done tweening?  set vars to final state and move on
			this._xscale = this._yscale = this.dstScale;
			this._alpha = this.dstAlpha;
			this._x = this.dstX;
			this._y = this.dstY;
			this.startTime = getTimer();
			this.state++;
			if (this.state >= 3)
				this._visible = false;
			// trace("  state " + this.state);
		}
		else if (r < 0) { // shouldn't happen
			trace("  negative r! " + r + " " + this.startTime + " " + getTimer());
		}
		else {
			// ease out for exit effects, or ease in for debut effects
			if ((state == 0 && r > .5) || (state == 2 && r < .5))
			{
			 	r = r*r*(3-2*r);
			 	r = r*r*(3-2*r);
			}
			this._xscale = this.srcScale + (this.dstScale-this.srcScale)*r;
			this._yscale = this._xscale;
			this._x = this.srcX + (this.dstX - this.srcX)*r;
			this._y = this.srcY + (this.dstY - this.srcY)*r;
			this._alpha = this.srcAlpha + (this.dstAlpha - this.srcAlpha)*r;
		}
		break;
	case 1:		// read pause
		var r = (getTimer() - this.startTime)/kReadDuration;
		if (r > 1 && this.isMouseIn != true) 
		{
			queueNext = true;
			this.state++;
			this.setupExit(tickerItemExit[this.idx]);
		}
		break;
	default:
		trace(" unsupported state " + this.state);
	}
	if (queueNext) 
	{
		_root.mcCtr = (_root.mcCtr + 1) % 2;
		_root.idx = (_root.idx+1) % tickerItems.length;
		_root["ticker_mc" + _root.mcCtr].getTickerItem(_root.idx);
	}
}

_root.mcCtr = 0;

var mc = this.attachMovie("ticker_mc", "ticker_mc0", 0);
mc.ticker_txt.autoSize = "left";
mc.ticker_txt.html = true;
mc.speed = 10;
mc.isMouseIn = false;
mc.onRollOver = function() { this.speed = 2; this.isMouseIn = true; }
mc.onRollOut = function() { this.speed = 10; this.isMouseIn = false; }

mc = this.attachMovie("ticker_mc", "ticker_mc1", 1);
mc.ticker_txt.autoSize = "left";
mc.ticker_txt.html = true;
mc.ticker_txt.htmlText = '';
mc.speed = 10;
mc.isMouseIn = false;
mc.onRollOver = function() { this.speed = 2; this.isMouseIn = true; }
mc.onRollOut = function() { this.speed = 10; this.isMouseIn = false; }

_root.idx = 0;
ticker_mc0.getTickerItem(0);
ticker_mc1._visible = false;
ticker_mc0.onEnterFrame = cycleTicker;
ticker_mc1.onEnterFrame = cycleTicker;
