﻿// Basic scrolling news ticker, controlled by an array
//
// Jim Bumgardner

SW = Stage.width; // scene width
SH = Stage.height; // scene height

var tickerItems = [
	'<font color="#FF0000"><a href="http://www.krazydad.com" target="_top">This ticker was brought to you by krazydad.com</a></font>',
	'<font color="#0000FF">This is the second item in the ticker.</font>',
	'<font color="#0000FF">This is the third item in the ticker.</font>',
	'<font color="#0000FF">This is the fourth item in the ticker.</font>',
	'<font color="#000000">This is the fifth item in the ticker.</font>',
	'<font color="#0000FF"><a href="http://www.krazydad.com" target="blank">This is the sixth item.</a></font>',
	'<font color="#0000FF"><a href="http://www.krazydad.com" target="blank">Item 7.</a></font>',
	'<font color="#330033"><a href="http://www.krazydad.com" target="_top">This ticker was brought to you by <u>krazydad.com</u></a>  -- stay tuned for more news...</font>'
	];

MovieClip.prototype.getTickerItem = function(n)
{
	this.idx = n;
	this.ticker_txt.htmlText = tickerItems[n];
	this.startTime = getTimer();
	this.ticker_txt._x = 0;
	this.ticker_txt._y = -this.ticker_txt.textHeight/2;
	this._x = SW;
	this._y = SH/2;
}

function cycleTicker()
{
	this._x -= this.speed;

	if (this._x <= -this.ticker_txt.textWidth)
		this.getTickerItem((this.idx+1)%tickerItems.length);
}

var mc = this.attachMovie("ticker_mc", "ticker_mc", i);
mc.ticker_txt.textColor = 0x000000;
mc.ticker_txt.autoSize = "left";
mc.ticker_txt.html = true;
mc.getTickerItem(0);
mc.idx = 0;
mc.speed = 10;
mc.onEnterFrame = cycleTicker;
mc.onRollOver = function() { this.speed = 2;  }
mc.onRollOut = function() { this.speed = 10; }
